﻿using System;
using System.Collections.Generic;
using Microsoft.OData.Edm;
using PpmsDataService.Models;

namespace PpmsDataService.Configuration
{
    using Microsoft.Web.Http;
    using Microsoft.Web.OData.Builder;
    using System.Web.OData.Builder;

    /// <summary>
    /// Represents the model configuration for orders.
    /// </summary>
    public class ProviderModelConfiguration : IModelConfiguration
    {
        /// <summary>
        /// Applies model configurations using the provided builder for the specified API version.
        /// </summary>
        /// <param name="builder">The <see cref="ODataModelBuilder">builder</see> used to apply configurations.</param>
        /// <param name="apiVersion">The <see cref="ApiVersion">API version</see> associated with the <paramref name="builder"/>.</param>
        public void Apply( ODataModelBuilder builder, ApiVersion apiVersion )
        {
            //Set all the Entity Types here
            builder.EntitySet<Provider>("Providers").EntityType.HasKey(p => p.Id);

            if ( apiVersion <= ApiVersions.V1 )
            {
              
                builder.Function("GetProviderByName").ReturnsFromEntitySet<Provider>("Providers").Parameter<string>("Name");
                builder.Function("GetProviderByModifiedOnDate").ReturnsFromEntitySet<Provider>("Providers").Parameter<DateTimeOffset>("ModifiedOnDate");

                var getProvidersByActiveDateRange = builder.Function("GetProvidersByActiveDateRange");
                getProvidersByActiveDateRange.Parameter<DateTimeOffset>("StartDate");
                getProvidersByActiveDateRange.Parameter<DateTimeOffset>("EndDate");
                getProvidersByActiveDateRange.ReturnsFromEntitySet<Provider>("Providers");

                var getProvidersAuthorized = builder.Function("GetProvidersAuthorized");
                getProvidersAuthorized.Parameter<int>("ProviderIdentifier");
                getProvidersAuthorized.Parameter<DateTimeOffset>("Date");
                getProvidersAuthorized.Parameter<int>("Network");
                getProvidersAuthorized.ReturnsFromEntitySet<ProviderAuthorization>("ProviderAuthorizations");

                var getProviderNetworks = builder.Function("GetProviderNetworks");
                getProviderNetworks.Parameter<int>("Npi");
                getProviderNetworks.ReturnsCollectionFromEntitySet<ProviderNetwork>("ProviderNetworks");

                var getProvidersByNetwork = builder.Function("GetProvidersByNetwork");
                getProvidersByNetwork.Parameter<int>("NetworkId");
                getProvidersByNetwork.ReturnsCollectionFromEntitySet<Provider>("Providers");

                var getProvidersByAffiliationType = builder.Function("GetProvidersByAffiliationType");
                getProvidersByAffiliationType.Parameter<int>("AffiliationTypeId");
                getProvidersByAffiliationType.ReturnsCollectionFromEntitySet<Provider>("Providers");

            }
            else if ( apiVersion == ApiVersions.V2 )
            {
                //builder.EntitySet<V2.Models.Provider>( "Providers" ).EntityType.HasKey( p => p.NpiKey );
            }
            else if ( apiVersion == ApiVersions.V3 )
            {
                //builder.EntitySet<V3.Models.Provider>( "Providers" ).EntityType.HasKey( p => p.NpiKey );
            }
        }
    }
}